/**
 * Intégrations des dépendences
 */
const express = require('express');
const morgan = require('morgan');
const setup = require('./setup');
const config = require('./config');
const fileUpload = require('express-fileupload');
/**
 * Intégration des routes stockées dans /routes
 */
const voice = require('./routes/voice');
const status = require('./routes/status');
const call = require('./routes/call');
const sms = require('./routes/sms');
const get = require('./routes/get');
const stream = require('./routes/stream');

/**
 * Ajout du middleware d'authentification => vérifie si l'on utilise bien l'API avec un mot de passe
 */
const auth = require('./middleware/authentification');

if (config.setupdone == 'false') setup();

/**
 * Partie express côté serveur web
 */
var app = express();
app.use(express.urlencoded({
    extended: true
}));
app.use(fileUpload({
    createParentPath: true
}));
//app.use(morgan('combined')); // Only used for debug http requests
app.use(express.static('public'))
app.get('/voice', voice.voiceUploadForm);
app.post('/voice/upload', voice.voiceUpload);
app.post('/status/', status);
app.post('/call', call);
app.post('/call/answerurl', voice.callAnswerReceiver);
app.post('/call/eventurl', voice.callEventReceiver);
app.post('/call/getotp', voice.callGetOtp);
app.post('/sms', sms);
app.post('/get', get);
app.get('/stream/:service', stream);

app.use(function(req, res) {
    res.status(404).json({
        error: 'Not found, or bad request method.'
    });
});

module.exports = app;
