module.exports = function(request, response) {
  /**
   * Intégration des dépendences SQLITE3
   */
  const sqlite3 = require('sqlite3').verbose();
  const db = new sqlite3.Database('./db/data.db');

  /**
   * Fichier contenant les configurations nécéssaires au bon fonctionnement du système
   */
  const config = require('../config');

  /**
   * Identification et déclaration Twilio
   */
  const Nexmo = require('@vonage/server-sdk');
  const nexmo = new Nexmo({
      apiKey: config.apiKey,
      apiSecret: config.apiSecret,
      applicationId: config.applicationId,
      privateKey: config.privateKey,
      signatureSecret: config.signatureSecret,
      signatureMethod: config.signatureMethod
  });

  /**
   * Récupération des variables postées permettant d'ordonner l'appel
   */
  var to = request.body.to || null;
  var user = request.body.user || null;
  var message = request.body.message;
  /**
   * Si il manque l'une des variable, transmettre l'erreur et empêcher le fonctionnement du système
   */
  if (to == null || user == null || message == null) {
      response.status(200).json({
          error: 'Please post all the informations needed.'
      });
      return false;
  }

  /**
   * Si le numéro de téléphone est correcte, alors on lance l'appel
   */
  if (to.match(/^\d{8,14}$/g) && !!user && !!message) {
      /**
       * API Twilio permettant d'émettre le SMS
       */
      nexmo.channel.send({"type": "sms", "number": '+'+to}, {"type": "sms", "number": config.smsid }, {
          'content' : {
              'type' : 'text',
              'text' : message
          }
      },
        (error, res) => {
              if (error) {
                console.log('SMS Error',error);
              }

              if (res) {
                  smssid = res['message_uuid'];

                  response.send(smssid);

                  /**
                   * Ajout à la DB Sqlite3 du SMS envoyé
                   */
                  db.run(`INSERT INTO sms(smssid, user, itsfrom, itsto, content,  service, date) VALUES(?, ?, ?, ?, ?, ?, ?)`, [smssid, user, config.smsid, to, message, message, Date.now()], function(err) {
                      if (err) {
                          return console.log(err.message);
                      }
                  });
              }
        });
  } else {
      response.status(200).json({
          error: 'Bad phone number or username or message.'
      });
  }
};
