module.exports = {
    voiceUploadForm(req, res){
        res.type('text/html').send(`
            <!DOCTYPE html>
            <html lang="en" dir="ltr">
                <head>
                    <meta charset="utf-8">
                    <title></title>
                </head>
                <body>
                    <form action="/voice/upload" method="post" enctype="multipart/form-data">
                        <input style='text-transform:lowercase' type="text" min="3" required name="service_name" placeholder="Service name..">
                        <input type="file" required name="service_file">
                        <button type="submit">Upload</button>
                    </form>
                </body>
            </html>
        `);
    },
    async voiceUpload(req, res) {
        const config = require('../config');
        const fs = require('fs');

        try {
            if(!req.files) {
                res.send('No file uploaded');
            } else if(!req.body.service_name) {
                res.send('No service name provided');
            } else {
                //Use the name of the input field (i.e. "avatar") to retrieve the uploaded file
                let avatar = req.files.service_file;
                let service_name = req.body.service_name.toLowerCase();

                if(!avatar.name.includes('.mp3')) {
                    res.send('Only mp3 format supported');
                }

                //Use the mv() method to place the file in upload directory (i.e. "uploads")
                avatar.mv('./public/voice/' + service_name + '.mp3');
                let location = `${config.serverurl}/voice/${service_name}.mp3`;
                var voices = JSON.parse(fs.readFileSync('./voices.json'));
                voices[service_name] = location;
                fs.writeFileSync('./voices.json', JSON.stringify(voices));
                //send response
                res.send('File is uploaded'+', Location : '+location);
            }
        } catch (err) {
            res.status(500).send(err);
        }
    },
    callAnswerReceiver(req, res){
        if(req.body.dtmf) {
            const fs = require('fs');
            let file_name = `./public/answers/${req.body.to}.json`;
            fs.writeFileSync(file_name, JSON.stringify(req.body));
            res.send("saved!");
        } else {
            res.send("waiting!");
        }
    },
    callEventReceiver(req, res){
        const fs = require('fs');
        if(req.body.to){
            let file_name = `./public/events/${req.body.to}-${(new Date()).getTime()}.json`;
            fs.writeFileSync(file_name, JSON.stringify(req.body));
            res.send("saved!");
        } else {
            res.send("waiting!");
        }
    },
    callGetOtp(req, res) {
        if(req.body.phone) {
            const fs = require('fs');
            let file_name = `./public/answers/${req.body.phone}.json`;

            if (fs.existsSync(file_name)) {
                let answer = JSON.parse(fs.readFileSync(file_name));
                res.type('application/json').send(
                    JSON.stringify({
                        'status' : 'success',
                        'otp' : answer['dtmf']['digits']
                    })
                );
            }

            res.type('application/json').send(
                JSON.stringify({
                    'status' : 'failed',
                    'message' : 'OTP is not available!'
                })
            );
        } else {
            res.send("waiting!");
        }
    }
};
